package gov.va.med.mhv.calendar.repository;

import java.util.List;

import gov.va.med.mhv.calendar.model.Reminder;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface ReminderRepository extends JpaRepository<Reminder, Long> {

	@Query("select reminder from Reminder reminder " +
			   "where reminder.userProfileId = :userProfileId ")
	public List<Reminder> findRemindersByUserProfile(@Param("userProfileId") Long userProfileId);
	
	@Query("select reminder from Reminder reminder " +
			"where reminder.userProfileId = :userProfileId " +
			"and reminder.reminderSent = :reminderSent")
	public List<Reminder> findRemindersByUserProfileAndSentState(@Param("userProfileId") Long userProfileId, @Param("reminderSent") Boolean reminderSent);
	
}
